/**
 * Klasse BoidFamily
 * 
 * 	Definiert die gemeinsamen Eigenschaften eines Schwarms, die hier abgelegten Attribute
 * 	gelten gemeinsam fr den gesamten Schwarm
 * 
 * Attribute:
 * 
 * 	name {String} eindeutiger Name zur Identifikation des Schwarms
 * 	minSpeed {float} Mindestgeschwindigkeit eines Boids in diesem Schwarm
 * 	maxSpeed {float} Maximalgeschwindigkeit eines Boids in diesem Schwarm
 * 	sightAngle {float} Sichtwinkel eines Boids in diesem Schwarm
 * 	sightRange {float} Sichtweite eines Boids in diesem Schwarm
 * 	cohesionRange {float} Abstand fr Verhalten "Zusammenhalt"
 * 	separationRange {float} Abstand fr Verhalten "Abstand halten"
 * 	maxRotation {float} maximal zugelassene Richtungsnderung eines Boids in diesem Schwarm
 * 	collisionRadius {float} Kollisionsradius eines Boids in diesem Schwarm
 * 	boidData {Boid[]} die Boids in diesem Schwarm
 * 	numBoids {Anzahl der Boids in diesem Schwarm
 * 	alienFamilyAvoidanceRange {float} Abstand zum Ausweichen anderer Schwrme
 * 	hostileAvoidanceRange {float} Abstand zum Ausweichen feindlicher Schwrme
 *	obstacleAvoidanceRange {float} Abstand zum Ausweichen eines Hindernisses
 *	birthPoint {float[3]} Ursprungsort dieses Schwarms
 *	isHostile {Boolean} ist dieser Schwarm feindlich?
 *	smoothBorder {float} Abstand bei dessen Unterschreitung eine weiche Wende an der Wand ausgefhrt wird
 *  
 *  
 */




/**
 * BoidFamily(name) : BoidFamily
 * 
 * 	Konstruktor und zugleich Definition der Klasse BoidFamily.
 * 	Hier absichtlich nur sehr wenig Parameter - gebrauchte Attribute
 * 	werden nach Bedarf gesetzt
 * 
 * Parameter
 * 	
 * 	name {String} Identifikator des Schwarms
 * 
 * Rckgabewert
 * 
 * 	{BoidFamily} neues BoidFamily Objekt
 * 
 */
function BoidFamily(name){
	this.name = name;
	this.minSpeed = 0.1;
	this.maxSpeed = 0.4;
	this.sightAngle = 120;
	this.sightRange = 10;
	this.cohesionRange = 3;
	this.separationRange = 1;
	this.maxRotation = 10;
	this.collisionRadius = 0.5;
	this.boidData = [];
	this.numBoids = 20;
	this.alienFamilyAvoidanceRange = 4;
	this.hostileAvoidanceRange = 6;
	this.obstacleAvoidanceRange = 2;
	this.birthPoint = [0,0,0];
	this.isHostile = false;
	this.smoothBorder = 4.0;
};

/**
 * Methode init() : void
 * 	
 * 	Erzeugt die Boids eines Schwarms
 * 
 * Klassenmethode zu BoidFamily
 */
BoidFamily.prototype.init = function(){
	for (var i=0; i < this.numBoids; i++) {
		this.boidData[i] = new Boid(this);
    }
};

/**
 * Methode doAction() : void
 * 
 * 	fhrt die Aktionen eines friedlichen Schwarms aus
 * 	Der Funktonsname ist zugegeben etwas unglcklich
 * 
 * Klassenmethode zu BoidFamily
 * 
 */
BoidFamily.prototype.doAction = function(){
	for (var i=0, max = this.boidData.length; i<max; i++) {
		
		if(!this.boidData[i].isAlive){
		//"totes" item reaktivieren, falls checkbox aktiv
    		if(inactive){
        		//Array mit "frischen" Items auffllen
		       	//also die mit .isAlive = false werden neu erzeugt			
		    	//genauer werden die alten "Objekte recycled" um nicht unntig Speicher zu verbrauchen
     			this.boidData[i].reactivate();
    		}
  		}
		else{
			var obstacleAvoided = this.boidData[i].avoidObstacles();
			var smoothBorders = this.boidData[i].smoothBorders(this.smoothBorder);
			var reflection = this.boidData[i].reflectBorders();
		
			//Neighborhood erzeugen - d.h. jeder Boid bekommt ein Array mit seinen sichtbaren Nachbarn			
			if(!smoothBorders && !reflection && !obstacleAvoided){
				this.boidData[i].generateNeighbors();
       		 		
				if(this.boidData[i].hostileCount > 0){
					this.boidData[i].flee();
				}
				else if(this.boidData[i].alienFamilyCount > 0){
					this.boidData[i].alienSeparate();
				}
				else if(this.boidData[i].separatorCount > 0){
					this.boidData[i].separate();
				}
				//keine Nachbarn - keine Aktion
				else if (this.boidData[i].nearestNeighborDistance < 0){
					//so ne art "do nothing"
				}
				else if (this.boidData[i].nearestNeighborDistance >=this.cohesionRange){
					this.boidData[i].alignPosition();
				} 		
				else if (this.boidData[i].nearestNeighborDistance > this.separationRange && this.boidData[i].nearestNeighborDistance < this.cohesionRange){
					this.boidData[i].alignDirection();
				}
				else{
					window.console.log('this should not happen');
				}
			}
		} 
	}
};

/**
 * Methode goHunting() : void
 * 
 * 	Fhrt die Aktionen eine feindlichen Schwarmes aus
 * 
 * Klassenmethode zu BoidFamily
 * 
 */
BoidFamily.prototype.goHunting = function(){
	//grundliegend von den "normalen" boids kopiert - aber mit modifikationen
	for (var i=0, max = this.boidData.length; i<max; i++) {
		
		if(!this.boidData[i].isAlive){
		//"totes" item reaktivieren, falls checkbox aktiv
			if(inactive){
				//Array mit "frischen" Items auffllen
				//also die mit .isAlive = false werden neu erzeugt			
				//genauer werden die alten "Objekte recycled" um nicht unntig Speicher zu verbrauchen
				this.boidData[i].reactivate();
			}
		}
		else{
			var smoothBorders = this.boidData[i].smoothBorders(this.smoothBorder);
			var reflection = this.boidData[i].reflectBorders();
			var obstacleAvoided = this.boidData[i].avoidObstacles();
			
			if(huntersEat)this.boidData[i].checkCollision();
		
			//Neighborhood erzeugen - d.h. jeder Boid bekommt ein Array mit seinen sichtbaren Nachbarn			
			if(!smoothBorders && !reflection && !obstacleAvoided){
				this.boidData[i].generateNeighborsForHostile();
				
				if(this.boidData[i].separatorCount > 0){
					this.boidData[i].separate();
				}
				else if (this.boidData[i].numNeighbors >0){
					this.boidData[i].alignPosition();
				}	
			}		
		}
	}
};
	